/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintInputFile;

public class InputFileBuilder {
    private final LanguageDetection langDetection;
    private final FileMetadata fileMetadata;

    public InputFileBuilder(LanguageDetection langDetection, FileMetadata fileMetadata) {
        this.langDetection = langDetection;
        this.fileMetadata = fileMetadata;
    }

    LanguageDetection langDetection() {
        return this.langDetection;
    }

    @CheckForNull
    SonarLintInputFile create(ClientInputFile inputFile) {
        SonarLintInputFile defaultInputFile = new SonarLintInputFile(inputFile);
        defaultInputFile.setType(inputFile.isTest() ? InputFile.Type.TEST : InputFile.Type.MAIN);
        String lang = this.langDetection.language(defaultInputFile);
        defaultInputFile.setLanguage(lang);
        Charset charset = inputFile.getCharset();
        defaultInputFile.init(this.fileMetadata.readMetadata(inputFile.getPath().toFile(), charset != null ? charset : Charset.defaultCharset()));
        return defaultInputFile;
    }
}

